function [P,N,J,L,H,Q] = Decoupling_observer(A,B,F,D1,C,D2)


[n,q] = size(F);
[~,l] = size(D1);
[p,~] = size(C);

% Augmented system
bar_A = [A D1]; 
bar_C = [C D2]; 
E = [eye(p) zeros(p,q)]; 
Phi_1 = [E;bar_C]; 
Xi_1 = eye(n+q);
Phi_2 = [eye(n+q); bar_C];

T1 = Xi_1*pinv(Phi_1)*[eye(n); zeros(p,n)];
T2 = (eye(n+p) - Phi_1*pinv(Phi_1))*[eye(n); zeros(p,n)];

H1 = Xi_1*pinv(Phi_1)*[zeros(n,p);eye(p)];
H2 = (eye(n+p) - Phi_1*pinv(Phi_1))*[zeros(n,p);eye(p)];

N2 = (eye(n+q+p) - Phi_2*pinv(Phi_2))*[eye(n+q); zeros(p,n+q)];
bar_L2 = (eye(n+q+p) - Phi_2*pinv(Phi_2))*[zeros(n+q,p);eye(p)];

% R_ob = rank(obsv(A0,C0)) % check observability of the pair (A0,C0)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Solve LMIs Eq.(7.43) & Eq.(7.44) in Theorem 7.2
beta = 1e-1;
gamma = 1e1;

% Pole placement, Eq. (7.67)
A0 = T1*bar_A*pinv(Phi_2)*[eye(n+q); zeros(p,n+q)];
C0 = [T2*bar_A*pinv(Phi_2)*[eye(n+q); zeros(p,n+q)]; N2];
TT2 = [T2; zeros(n+q+p,n)];
b = -3; a = -20;

% Using Matlab LMI toolbox
setlmis([]);

P = lmivar(1,[n+q,1]); 
Q = lmivar(2,[p,l]); 
M = lmivar(2,[n+q,2*n+2*p+q]); 

% lmi 1
lmiterm([-1 1 1 P], 1, 1);
lmiterm([1 1 1 0], 0);

% lmi 2
lmiterm([-2 1 1 0], beta);
lmiterm([-2 1 2 P], 1, T1*F);
lmiterm([-2 1 2 M], 1, -TT2*F);
lmiterm([-2 1 2 Q], -bar_C',1);
lmiterm([-2 2 2 0], beta);
lmiterm([2 1 1 0], 0);

% lmi 4
lmiterm([4 1 1 P], 1, A0, 's');
lmiterm([4 1 1 M], -1, C0, 's');

lmiterm([4 1 1 0], gamma^2);

% lmi 5
lmiterm([5 1 1 P], 1, A0, 's');
lmiterm([5 1 1 M], -1, C0, 's');
lmiterm([5 1 1 P], -2*b, 1);

lmiterm([5 1 1 P], -1, A0, 's');
lmiterm([5 1 1 M], 1, C0, 's');
lmiterm([5 1 1 P], 2*a, 1);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
lmis = getlmis;

[tmin, xfeasp] = feasp(lmis);
P = dec2mat(lmis,  xfeasp, P);
Q = dec2mat(lmis,  xfeasp, Q);
M = dec2mat(lmis,  xfeasp, M);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Y = inv(P)*M;
Y1 = Y*[eye(n+p); zeros(n+p+q,n+p)];
Y2 = Y*[zeros(n+p,n+p+q);eye(n+p+q)];

T = T1 - Y1*T2;
H = H1 - Y1*H2;

Xi2 = T*bar_A;
N1 = Xi2*pinv(Phi_2)*[eye(n+q); zeros(p,n+q)];
bar_L1 = Xi2*pinv(Phi_2)*[zeros(n+q,p); eye(p)];
N = N1 - Y2*N2;
bar_L = bar_L1 - Y2*bar_L2;
L = bar_L + N*H;

J = T*B;
W = inv(P)*bar_C'*Q;

